import RPi.GPIO as GPIO
import time

GPIO.setmode(GPIO.BOARD)

coil_A_1_pin = 11
coil_A_2_pin = 13
coil_B_1_pin = 15
coil_B_2_pin = 19

GPIO.setup(coil_A_1_pin, GPIO.OUT)
GPIO.setup(coil_A_2_pin, GPIO.OUT)
GPIO.setup(coil_B_1_pin, GPIO.OUT)
GPIO.setup(coil_B_2_pin, GPIO.OUT)

def setStep(w1, w2, w3, w4):
    GPIO.output(coil_A_1_pin, w1)
    GPIO.output(coil_A_2_pin, w2)
    GPIO.output(coil_B_1_pin, w3)
    GPIO.output(coil_B_2_pin, w4)
         

def forward(delay, steps):  
  for i in range(0, steps):
      setStep(1, 0, 0, 0)
      time.sleep(delay)
      setStep(0, 1, 0, 0)
      time.sleep(delay)
      setStep(0, 0, 1, 0)
      time.sleep(delay)
      setStep(0, 0, 0, 1)
      time.sleep(delay)

def backward(delay, steps):  
  for i in range(0, steps):
      setStep(0, 0, 0, 1)
      time.sleep(delay)
      setStep(0, 0, 1, 0)
      time.sleep(delay)
      setStep(0, 1, 0, 0)
      time.sleep(delay)
      setStep(1, 0, 0, 0)
      time.sleep(delay)
                                  
                                  
forward(0.1,30)
backward(0.1,30)

GPIO.cleanup()                                  

