-- Adminer 3.0.0-dev MySQL dump

SET NAMES utf8;
SET foreign_key_checks = 0;
SET time_zone = 'SYSTEM';
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

CREATE DATABASE `europen` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_czech_ci */;
USE `europen`;

DROP TABLE IF EXISTS `skupina`;
CREATE TABLE `skupina` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nazev` varchar(30) COLLATE utf8_czech_ci NOT NULL,
  `uzivatelu` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nazev` (`nazev`),
  KEY `uzivatelu` (`uzivatelu`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

INSERT INTO `skupina` (`id`, `nazev`, `uzivatelu`) VALUES
(1,	'admin test',	4),
(2,	'user',	3),
(3,	'disabled',	4);

DELIMITER ;;

CREATE TRIGGER `skupina_ai` AFTER INSERT ON `skupina` FOR EACH ROW
INSERT INTO skupina_hledani (id, nazev) VALUES (NEW.id, NEW.nazev);;

DELIMITER ;

DROP TABLE IF EXISTS `skupina_hledani`;
CREATE TABLE `skupina_hledani` (
  `id` int(11) NOT NULL,
  `nazev` varchar(30) COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `nazev` (`nazev`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

INSERT INTO `skupina_hledani` (`id`, `nazev`) VALUES
(1,	'admin test'),
(3,	'disabled'),
(2,	'user');

DROP TABLE IF EXISTS `uzivatel`;
CREATE TABLE `uzivatel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `vytvoreno` datetime DEFAULT NULL,
  `skupina` int(11) NOT NULL,
  `stav` enum('neschválený','aktivní','smazaný') COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`),
  KEY `skupina` (`skupina`,`vytvoreno`),
  KEY `vytvoreno` (`vytvoreno`),
  CONSTRAINT `uzivatel_ibfk_1` FOREIGN KEY (`skupina`) REFERENCES `skupina` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

INSERT INTO `uzivatel` (`id`, `login`, `vytvoreno`, `skupina`, `stav`) VALUES
(1,	'cyril',	'2010-10-07 00:00:00',	2,	'neschválený'),
(2,	'čeněk',	'2010-10-07 00:00:00',	3,	'neschválený'),
(3,	'mirek',	'2010-10-08 00:00:00',	2,	'neschválený'),
(4,	'login4',	'2010-10-09 00:00:00',	1,	'neschválený'),
(5,	'login5',	'2010-10-06 00:00:00',	1,	'neschválený'),
(6,	'login6',	'2010-10-06 00:00:00',	3,	'neschválený'),
(7,	'login7',	'2010-10-06 00:00:00',	2,	'neschválený'),
(8,	'login8',	'2010-10-06 00:00:00',	3,	'neschválený'),
(10,	'hugo',	'2010-10-10 00:00:00',	1,	'neschválený'),
(12,	'chyba',	'2010-10-11 21:00:00',	3,	'neschválený'),
(13,	'alois',	'2010-10-11 21:32:44',	1,	'neschválený');

DELIMITER ;;

CREATE TRIGGER `uzivatel_bi` BEFORE INSERT ON `uzivatel` FOR EACH ROW
SET NEW.vytvoreno = NOW();;

CREATE TRIGGER `uzivatel_ai` AFTER INSERT ON `uzivatel` FOR EACH ROW
UPDATE skupina SET uzivatelu = uzivatelu + 1 WHERE id = NEW.skupina;;

CREATE TRIGGER `uzivatel_bu` BEFORE UPDATE ON `uzivatel` FOR EACH ROW
IF CHAR_LENGTH(NEW.login) < 3 THEN
    DO `Login musí mít alespoň tři znaky.`;
END IF;;

CREATE TRIGGER `uzivatel_au` AFTER UPDATE ON `uzivatel` FOR EACH ROW
UPDATE skupina
SET uzivatelu = uzivatelu + IF(id = NEW.skupina, 1, -1)
WHERE id IN (OLD.skupina, NEW.skupina) AND OLD.skupina != NEW.skupina;;

CREATE TRIGGER `uzivatel_ad` AFTER DELETE ON `uzivatel` FOR EACH ROW
UPDATE skupina SET uzivatelu = uzivatelu - 1 WHERE id = OLD.skupina;;

DELIMITER ;

DROP VIEW IF EXISTS `uzivatel_pohled`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `uzivatel_pohled` AS select `uzivatel`.`id` AS `id`,`uzivatel`.`login` AS `login`,`uzivatel`.`vytvoreno` AS `vytvoreno`,`uzivatel`.`skupina` AS `skupina` from `uzivatel`;

