<?php
function demo($params) {
	// přímé vložení všech iframe zpomaluje první načtení
	return "<li><div onclick=\"this.onclick = function () { }; this.nextSibling.appendChild(demo('" . htmlspecialchars("adminer/?username=&db=europen&$params") . "'));\">Demo</div><p>\n";
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN">
<html lang="cs">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Problémy a šikovné vlastnosti MySQL</title>
<meta name="copyright" content="© 2010 Jakub Vrána">
<meta name="duration" content="50">
<link rel="stylesheet" type="text/css" href="slidy/styles/slidy.css">
<link rel="stylesheet" type="text/css" href="slidy/styles/w3c-blue.css">
<script type="text/javascript" src="slidy/scripts/slidy.js"></script>
<script type="text/javascript">
function demo(src) {
	var iframe = document.createElement('iframe');
	iframe.width = '100%';
	iframe.height='600';
	iframe.src = src;
	return iframe;
}
</script>
<body>

<div class="background">
	<img id="head-icon" src="slidy/graphics/icon-blue.png" alt="">
	<a href="http://www.mysql.com/"><img id="head-logo" src="mysql-logo.png" alt="Powered by MySQL" style="padding: 5px 10px; background: white;"></a>
</div>

<div class="slide cover">
	<h1 style="margin: 20% 0 0;">Problémy a šikovné vlastnosti MySQL</h1>
	<p>EurOpen 2010, Podlesí
	<p>Jakub Vrána – <a href="mailto:jakub&#64;vrana.cz">jakub&#64;vrana.cz</a>
</div>

<h1>O autorovi</h1>
	<ul class="outline">
	<li>MySQL od verze 3.23
	<li>Autor webového správce databáze <a href="http://www.adminer.org/"><strong>Adminer</strong></a>
		<ul>
		<li>K dispozici pro <strong>MySQL</strong>, <strong>PostgreSQL</strong>, <strong>SQLite</strong>, <strong>MS SQL</strong> a <strong>Oracle</strong>
		</ul>
	<li>Lektor školení MySQL
		<ul>
		<li><a href="http://php.vrana.cz/skoleni-navrh-a-pouzivani-mysql-databaze.php">Návrh a používání MySQL databáze</a>
		<li><a href="http://php.vrana.cz/skoleni-konfigurace-a-vykonnost-mysql.php">Konfigurace a výkonnost MySQL</a>
		</ul>
	<li>MySQL Community Contributor
	</ul>

<div class="slide cover title">
	<h1 style="margin: 20% 0;">Problémy MySQL a jejich obejití</h1>
</div>

<h1>Nelze nastavit aktuální výchozí čas</h1>
	<ul class="outline">
	<li>Funguje pouze u jednoho sloupce typu <code class="language-sql_code">timestamp</code>
	<li><?php echo demo("edit=uzivatel"); ?>
	</ul>

<h1>Sestupné indexy</h1>
	<ul class="outline">
	<li>Nemíchat pořadí řazení <code class="language-sql">ORDER BY skupina DESC, poradi</code>
	<li>Funguje i <code class="language-sql">GROUP BY skupina DESC</code>
	<li><?php echo demo("sql=" . urlencode("EXPLAIN SELECT * FROM uzivatel ORDER BY skupina, vytvoreno DESC LIMIT 5")); ?>
	</ul>

<h1>Indexy nad výsledkem funkce</h1>
	<ul class="outline">
	<li>Sloupce v podmínce uvádět samostatně
	<li>Výsledek složitějších funkcí si ukládat triggerem
	<li><?php echo demo("sql=" . urlencode("EXPLAIN SELECT * FROM uzivatel WHERE vytvoreno + INTERVAL 1 DAY >= NOW()")); ?>
	</ul>

<h1>Využití indexů v poddotazu</h1>
	<ul class="outline">
	<li>Pro zpracování výsledku (<code class="language-sql">SELECT * FROM (SELECT) tab ORDER BY sloupec</code>) lze vytvořit pohled
	<li>Seznam hodnot (<code class="language-sql">WHERE id IN (SELECT)</code>) je lepší vyhodnotit ve dvou dotazech
	<li><?php echo demo("sql=" . urlencode("EXPLAIN SELECT * FROM (SELECT * FROM uzivatel) derived ORDER BY vytvoreno DESC LIMIT 5")); ?>
	</ul>

<h1>Materializované pohledy</h1>
	<ul class="outline">
	<li>Dopočítávané sloupce a aktualizace pomocí triggerů
	<li><?php echo demo("select=skupina"); ?>
	</ul>

<h1>Omezující podmínky (<code class="language-sql">CHECK</code>)</h1>
	<ul class="outline">
	<li>Lze zajistit pomocí triggeru
	<li>Od MySQL 5.5 lze pro vyvolání chyby použít příkaz <code class="language-sql">SIGNAL</code>
	<li><?php echo demo("edit=uzivatel&where[id]=12"); ?>
	</ul>

<h1>Další omezení</h1>
	<ul class="outline">
	<li>Trigger nemůže měnit stejnou tabulku
		<ul>
		<li>Modifikovat lze pouze aktuální záznam pomocí <code>NEW</code>
		</ul>
	<li>Triggery se nespustí při <code class="language-sql">ON DELETE CASCADE</code>
		<ul>
		<li>Záznamy mazat ručně
		</ul>
	<li>Příkazy ukončující transakci
		<ul>
		<li><code class="language-sql">CREATE TABLE</code>, <code class="language-sql">GRANT</code>,  …
		</ul>
	</ul>

<div class="slide cover title">
	<h1 style="margin: 20% 0 0;">Šikovné vlastnosti MySQL a jejich využití</h1>
</div>

<h1>Výborná podpora kódování</h1>
	<ul class="outline">
	<li><code class="language-sql">COLLATE utf8_czech_ci</code> při vytváření databáze, tabulky a sloupce
	<li><code class="language-sql">SET NAMES utf8</code> po navázání komunikace
	<li><?php echo demo("select=uzivatel&order=login"); ?>
	</ul>

<h1>Agregační funkce <code class="language-sql">GROUP_CONCAT</code></h1>
	<ul class="outline">
	<li>Pořadí v řetězci a oddělovač lze nastavit
	<li><?php echo demo("select=uzivatel&columns[0][col]=skupina&columns[1][fun]=group_concat&columns[1][col]=login"); ?>
	</ul>

<h1>Klauzule <code class="language-sql">ON DUPLICATE KEY UPDATE</code></h1>
	<ul class="outline">
	<li>Importy
	<li>Statistické informace
	<li>Unikátní číselníky
	<li><?php echo demo("sql=" . urlencode("INSERT INTO skupina (nazev, uzivatelu)\nVALUES ('user', 0)\nON DUPLICATE KEY UPDATE id = LAST_INSERT_ID(id);\n\nSELECT LAST_INSERT_ID();\n")); ?>
	</ul>

<h1>Fulltextové vyhledávání (u tabulek typu <strong>MyISAM</strong>)</h1>
	<ul class="outline">
	<li>Data do nich lze kopírovat triggerem
	<li><code class="language-sql">MATCH (nadpis, clanek) AGAINST ('$slova' IN BOOLEAN MODE)</code>
	<li>Nastavení <code class="language-sqlset">ft_stopword_file</code>, <code class="language-sqlset">ft_min_word_len</code>, <code class="language-sqlset">ft_boolean_syntax</code>
	<li><?php echo demo("select=skupina_hledani&fulltext[nazev]=test"); ?>
	</ul>

<h1>Datový typ <code class="language-sql_code">enum</code></h1>
	<ul class="outline">
	<li>Pevné výčty, jejichž změna si vyžádá změnu aplikace
	<li>Neplatná hodnota se převede na prázdný řetězec
	<li>Datový typ <code class="language-sql_code">set</code> se dá použít pro efektivní uložení více pravdivostních hodnot
	<li><?php echo demo("edit=uzivatel"); ?>
	</ul>

<h1>Příznak <code class="language-sql">SQL_CALC_FOUND_ROWS</code></h1>
	<ul class="outline">
	<li>Funkce <code class="language-sql">FOUND_ROWS</code> vrátí počet řádek nehledě na <code class="language-sql">LIMIT</code>
	<li><?php echo demo("sql=" . urlencode("SELECT SQL_CALC_FOUND_ROWS * FROM uzivatel LIMIT 5;\n\nSELECT FOUND_ROWS();\n")); ?>
	</ul>

<h1>Další šikovné vlastnosti</h1>
	<ul class="outline">
	<li>Příznak <code class="language-sql">AUTO_INCREMENT</code>
		<ul>
		<li>Snadné vytváření primárních klíčů
		<li>U tabulek typu <strong>MyISAM</strong> lze rozdělit do skupin
		</ul>
	<li>Replikace (automatické kopírování na jiný server)
		<ul>
		<li>Využitelné pro zálohování a rozkládání zátěže
		<li>Kopírování příkazů (od 5.1 volitelně řádek)
		<li>Asynchronní (od 5.5 volitelně semisynchronní)
		</ul>
	<li>Rychlý <code class="language-sql">COMMIT</code>, pomalý <code class="language-sql">ROLLBACK</code>
		<ul>
		<li>Data se zapisují přímo na cílové místo
		<li><code class="language-sql">ROLLBACK</code> obnovuje data z logu
		</ul>
	</ul>

<div class="slide cover title">
	<h1 style="margin: 20% 0;">Otázky?</h1>
</div>

<script type="text/javascript" src="jush/jush.js"></script>
<script type="text/javascript">
jush.style('jush/jush.css');
jush.create_links = ' target="_blank"';
jush.highlight_tag('code');
</script>
