class Task < ActiveRecord::Base
  
  validates_presence_of :title, :due_on

  named_scope :ordered, :order => 'due_on'

  private
  
  def validate
    self.errors.add(:due_on, "cannot be in the past") if self.due_on && self.due_on < Time.now.to_date
  end
  
end
